/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.tsdb.influxdb.converter;

import org.influxdb.dto.QueryResult;
import org.springframework.core.convert.converter.Converter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>Description: Influxdb QueryRequest 转换器抽象定义 </p>
 *
 * @author : gengwei.zheng
 * @date : 2023/11/5 21:02
 */
public abstract class AbstractQueryResultToListConverter<T> implements Converter<QueryResult, List<T>> {


    /**
     * Influxdb 查询结果一行数据根据列名转换为 Map
     *
     * @param item    查询结果中的一行数据
     * @param columns 查询结果列名
     * @param tags    标签
     * @return 以列名为key，每行数据各个point为值的 Map
     */
    protected Map<String, Object> pointToMap(List<Object> item, List<String> columns, Map<String, String> tags) {
        Map<String, Object> result = new HashMap<>(tags);

        for (int i = 0; i < columns.size(); i++) {
            String key = columns.get(i);
            Object value = item.get(i);
            result.put(key, value);
        }

        return result;
    }
}
