/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.tsdb.influxdb.converter;

import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.bean.copier.CopyOptions;
import org.influxdb.dto.QueryResult;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * <p>Description: Influxdb QueryRequest 转实体转换器抽象定义 </p>
 *
 * @author : gengwei.zheng
 * @date : 2023/11/5 21:05
 */
public abstract class AbstractQueryResultToEntityListConverter<T> extends AbstractQueryResultToListConverter<T> {

    protected abstract Class<T> getEntityClass();

    @Override
    public List<T> convert(QueryResult queryResult) {

        List<QueryResult.Result> results = queryResult.getResults();

        return results
                .stream()
                .flatMap(result -> Optional.ofNullable(result.getSeries()).orElse(new ArrayList<>())
                        .stream()
                        .flatMap(series -> Optional.ofNullable(series.getValues()).orElse(new ArrayList<>())
                                .stream()
                                .map(item -> {
                                    Map<String, Object> map = pointToMap(item, series.getColumns(), series.getTags());
                                    return BeanUtil.toBean(map, getEntityClass(), CopyOptions.of());
                                })))
                .toList();
    }
}
