/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.transform.emqx.transformer;

import cn.herodotus.stirrup.core.event.domain.emqx.WebhookClientCheckAuthenticationComplete;
import cn.herodotus.stirrup.core.event.domain.emqx.WebhookClientConnectAck;
import cn.herodotus.stirrup.core.event.domain.emqx.WebhookClientConnected;
import cn.herodotus.stirrup.core.event.domain.emqx.WebhookClientDisconnected;
import cn.herodotus.stirrup.core.event.domain.emqx.WebhookMessageAcked;
import cn.herodotus.stirrup.core.event.domain.emqx.WebhookMessageDelivered;
import cn.herodotus.stirrup.core.event.domain.emqx.WebhookMessageDropped;
import cn.herodotus.stirrup.core.event.domain.emqx.WebhookSessionSubscribed;
import cn.herodotus.stirrup.core.event.domain.emqx.WebhookSessionUnsubscribed;
import cn.herodotus.stirrup.core.event.event.emqx.WebhookClientCheckAuthenticationCompleteEvent;
import cn.herodotus.stirrup.core.event.event.emqx.WebhookClientConnectAckEvent;
import cn.herodotus.stirrup.core.event.event.emqx.WebhookClientConnectedEvent;
import cn.herodotus.stirrup.core.event.event.emqx.WebhookClientDisconnectedEvent;
import cn.herodotus.stirrup.core.event.event.emqx.WebhookMessageAckedEvent;
import cn.herodotus.stirrup.core.event.event.emqx.WebhookMessageDeliveredEvent;
import cn.herodotus.stirrup.core.event.event.emqx.WebhookMessageDroppedEvent;
import cn.herodotus.stirrup.core.event.event.emqx.WebhookSessionSubscribedEvent;
import cn.herodotus.stirrup.core.event.event.emqx.WebhookSessionUnsubscribedEvent;
import cn.herodotus.stirrup.core.foundation.json.jackson2.utils.Jackson2Utils;
import java.util.Map;
import org.springframework.context.ApplicationEvent;
import org.springframework.integration.transformer.AbstractPayloadTransformer;

public class WebhookMapToEventTransformer
extends AbstractPayloadTransformer<Map<String, Object>, ApplicationEvent> {
    protected ApplicationEvent transformPayload(Map<String, Object> payload) {
        Object event = payload.get("event");
        String type = String.valueOf(event);
        return this.process(type, payload);
    }

    private <T> T getBean(Map<String, Object> data, Class<T> beanClass) {
        return (T)Jackson2Utils.toObject(data, beanClass);
    }

    private ApplicationEvent process(String type, Map<String, Object> data) {
        return switch (type) {
            case "client.connack" -> new WebhookClientConnectAckEvent(this.getBean(data, WebhookClientConnectAck.class));
            case "client.connected" -> new WebhookClientConnectedEvent(this.getBean(data, WebhookClientConnected.class));
            case "client.disconnected" -> new WebhookClientDisconnectedEvent(this.getBean(data, WebhookClientDisconnected.class));
            case "message.acked" -> new WebhookMessageAckedEvent(this.getBean(data, WebhookMessageAcked.class));
            case "message.delivered" -> new WebhookMessageDeliveredEvent(this.getBean(data, WebhookMessageDelivered.class));
            case "message.dropped" -> new WebhookMessageDroppedEvent(this.getBean(data, WebhookMessageDropped.class));
            case "session.subscribed" -> new WebhookSessionSubscribedEvent(this.getBean(data, WebhookSessionSubscribed.class));
            case "session.unsubscribed" -> new WebhookSessionUnsubscribedEvent(this.getBean(data, WebhookSessionUnsubscribed.class));
            default -> new WebhookClientCheckAuthenticationCompleteEvent(this.getBean(data, WebhookClientCheckAuthenticationComplete.class));
        };
    }
}

