/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.transform.emqx.transformer;

import cn.herodotus.stirrup.core.event.domain.emqx.SystemClientConnected;
import cn.herodotus.stirrup.core.event.domain.emqx.SystemClientDisconnected;
import cn.herodotus.stirrup.core.event.domain.emqx.SystemClientSubscribed;
import cn.herodotus.stirrup.core.event.domain.emqx.SystemClientUnsubscribed;
import cn.herodotus.stirrup.core.event.event.emqx.SystemClientConnectedEvent;
import cn.herodotus.stirrup.core.event.event.emqx.SystemClientDisconnectedEvent;
import cn.herodotus.stirrup.core.event.event.emqx.SystemClientSubscribedEvent;
import cn.herodotus.stirrup.core.event.event.emqx.SystemClientUnsubscribedEvent;
import cn.herodotus.stirrup.core.foundation.json.jackson2.utils.Jackson2Utils;
import cn.herodotus.stirrup.transform.emqx.utils.EmqxMessageUtils;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hutool.core.text.StrUtil;
import org.springframework.context.ApplicationEvent;
import org.springframework.integration.transformer.AbstractTransformer;
import org.springframework.messaging.Message;

public class SystemClientByteArrayToEventTransformer
extends AbstractTransformer {
    protected Object doTransform(Message<?> message) {
        String topic = this.parseTopic(message);
        byte[] payload = EmqxMessageUtils.getPayload(message);
        return this.convert(topic, StrUtil.utf8Str((Object)payload));
    }

    private <T> T getBean(String data, Class<T> beanClass) {
        return (T)Jackson2Utils.toObject((String)data, beanClass);
    }

    private String parseTopic(Message<?> message) {
        String topic = EmqxMessageUtils.getTopic(message);
        String[] elements = StringUtils.split((String)topic, (String)"/");
        return elements[elements.length - 1];
    }

    private ApplicationEvent convert(String type, String data) {
        return switch (type) {
            case "connected" -> new SystemClientConnectedEvent(this.getBean(data, SystemClientConnected.class));
            case "disconnected" -> new SystemClientDisconnectedEvent(this.getBean(data, SystemClientDisconnected.class));
            case "subscribed" -> new SystemClientSubscribedEvent(this.getBean(data, SystemClientSubscribed.class));
            default -> new SystemClientUnsubscribedEvent(this.getBean(data, SystemClientUnsubscribed.class));
        };
    }
}

