/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.transform.emqx.outbound;

import cn.herodotus.stirrup.transform.emqx.converter.AbstractInfluxdbPointConverter;
import cn.herodotus.stirrup.transform.emqx.converter.Influxdb2Converter;
import cn.herodotus.stirrup.transform.emqx.converter.MessageToRecordConverter;
import cn.herodotus.stirrup.tsdb.influxdb2.pool.Influxdb2ClientObjectPool;
import com.influxdb.client.InfluxDBClient;
import com.influxdb.client.WriteApiBlocking;
import com.influxdb.client.domain.WritePrecision;
import com.influxdb.client.write.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.messaging.Message;

public class Influxdb2StoringMessageHandler
extends AbstractMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(Influxdb2StoringMessageHandler.class);
    private Influxdb2Converter<?> influxdb2Converter;
    private final Influxdb2ClientObjectPool influxdb2ClientObjectPool;

    public Influxdb2StoringMessageHandler(Influxdb2ClientObjectPool influxdb2ClientObjectPool) {
        this(influxdb2ClientObjectPool, new MessageToRecordConverter());
    }

    public Influxdb2StoringMessageHandler(Influxdb2ClientObjectPool influxdb2ClientObjectPool, Influxdb2Converter<?> influxdb2Converter) {
        this.influxdb2ClientObjectPool = influxdb2ClientObjectPool;
        this.influxdb2Converter = influxdb2Converter;
    }

    public void setInfluxdb2Converter(Influxdb2Converter<?> influxdb2Converter) {
        this.influxdb2Converter = influxdb2Converter;
    }

    protected void handleMessageInternal(Message<?> message) {
        Object payload = message.getPayload();
        InfluxDBClient influxDBClient = (InfluxDBClient)this.influxdb2ClientObjectPool.get();
        WriteApiBlocking writeApi = influxDBClient.getWriteApiBlocking();
        switch (this.getWriteMode().ordinal()) {
            case 1: {
                writeApi.writePoint((Point)((AbstractInfluxdbPointConverter)this.influxdb2Converter).convert(payload));
                break;
            }
            case 0: {
                writeApi.writeRecord(WritePrecision.NS, ((MessageToRecordConverter)this.influxdb2Converter).convert(payload));
                break;
            }
            default: {
                writeApi.writeMeasurement(WritePrecision.NS, this.influxdb2Converter.convert(payload));
            }
        }
        log.debug("[Herodotus] |- Iot integration write message {} to influxdb2.", message);
        this.influxdb2ClientObjectPool.close((Object)influxDBClient);
    }

    private WriteMode getWriteMode() {
        if (this.influxdb2Converter instanceof MessageToRecordConverter) {
            return WriteMode.RECORD;
        }
        if (this.influxdb2Converter instanceof AbstractInfluxdbPointConverter) {
            return WriteMode.POINT;
        }
        return WriteMode.POJO;
    }

    private static enum WriteMode {
        RECORD,
        POINT,
        POJO;

    }
}

