/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.transform.emqx.config;

import cn.herodotus.stirrup.transform.emqx.annotation.ConditionalOnEmqxWebhookEvent;
import cn.herodotus.stirrup.transform.emqx.storage.WebhookDemoListener;
import cn.herodotus.stirrup.transform.emqx.transformer.WebhookMapToEventTransformer;
import jakarta.annotation.PostConstruct;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.integration.core.GenericTransformer;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.MessageChannelSpec;
import org.springframework.integration.dsl.MessageChannels;
import org.springframework.integration.dsl.MessagingGatewaySpec;
import org.springframework.integration.event.outbound.ApplicationEventPublishingMessageHandler;
import org.springframework.integration.http.dsl.Http;
import org.springframework.integration.http.dsl.HttpRequestHandlerEndpointSpec;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;

@Configuration(proxyBeanMethods=false)
@ConditionalOnEmqxWebhookEvent
public class EmqxWebhookToEventFlowConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmqxWebhookToEventFlowConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- SDK [Emqx Webhook To Event Flow] Auto Configure.");
    }

    @Bean(value={"emqxDefaultWebhookHttpInboundChannel"})
    public MessageChannel emqxWebhookHttpInboundChannel() {
        return (MessageChannel)MessageChannels.direct().getObject();
    }

    @Bean
    public ApplicationEventPublishingMessageHandler emqxWebhookEventPublishingMessageHandler() {
        ApplicationEventPublishingMessageHandler handler = new ApplicationEventPublishingMessageHandler();
        handler.setPublishPayload(true);
        return handler;
    }

    @Bean
    public IntegrationFlow emqxWebhookToEventFlow(ApplicationEventPublishingMessageHandler emqxWebhookEventPublishingMessageHandler, @Qualifier(value="emqxDefaultWebhookHttpInboundChannel") MessageChannel emqxWebhookHttpInboundChannel) {
        return ((IntegrationFlowBuilder)((IntegrationFlowBuilder)((IntegrationFlowBuilder)((IntegrationFlowBuilder)IntegrationFlow.from((MessagingGatewaySpec)((HttpRequestHandlerEndpointSpec)((HttpRequestHandlerEndpointSpec)Http.inboundChannelAdapter((String[])new String[]{"/emqx/webhook"}).requestMapping(m -> m.methods(new HttpMethod[]{HttpMethod.POST}))).requestPayloadType(ResolvableType.forClass(Map.class, LinkedHashMap.class))).statusCodeFunction(s -> HttpStatus.OK)).channel(emqxWebhookHttpInboundChannel)).transform((GenericTransformer)new WebhookMapToEventTransformer())).channel((MessageChannelSpec)MessageChannels.direct((String)"emqxDefaultEventOutboundChannel"))).handle((MessageHandler)emqxWebhookEventPublishingMessageHandler)).get();
    }

    @Bean
    public WebhookDemoListener webhookDemoListener() {
        return new WebhookDemoListener();
    }
}

