/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.transform.emqx.aggregator;

import cn.herodotus.stirrup.transform.emqx.domain.StatsIndicator;
import cn.herodotus.stirrup.transform.emqx.domain.SystemTopic;
import cn.herodotus.stirrup.transform.emqx.enums.SystemTopicCategory;
import cn.herodotus.stirrup.transform.emqx.utils.EmqxMessageUtils;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.dromara.hutool.core.text.StrUtil;
import org.springframework.integration.aggregator.MessageGroupProcessor;
import org.springframework.integration.store.MessageGroup;
import org.springframework.messaging.Message;

public class MonitorAggregatingMessageGroupProcessor
implements MessageGroupProcessor {
    private String node;
    private String version;
    private Instant uptime;
    private LocalDateTime datetime;
    private StatsIndicator stats;

    public Object processMessageGroup(MessageGroup group) {
        this.stats = new StatsIndicator();
        this.analysis(group.getMessages());
        return this.stats;
    }

    private void setNode(String node) {
        this.stats.setNode(node);
    }

    private void setVersion(String version) {
        this.stats.setVersion(version);
    }

    private void analysis(Collection<Message<?>> messages) {
        messages.forEach(this::analysis);
    }

    private void analysis(Message<?> message) {
        String topic = EmqxMessageUtils.getTopic(message);
        byte[] payload = EmqxMessageUtils.getPayload(message);
        SystemTopic systemTopic = this.resolvingTopic(topic);
        switch (systemTopic.systemTopicCategory()) {
            case INFO: {
                if (EmqxMessageUtils.isVersion(systemTopic)) {
                    this.setVersion(StrUtil.utf8Str((Object)payload));
                }
                this.stats.setTime(Instant.ofEpochMilli(EmqxMessageUtils.getTimestamp(message)));
                break;
            }
            case STATS: {
                this.processStats(systemTopic.topicName(), NumberUtils.toInt((String)StrUtil.utf8Str((Object)payload)));
                break;
            }
        }
    }

    private SystemTopic resolvingTopic(String topic) {
        int count = StringUtils.countMatches((CharSequence)String.valueOf(topic), (CharSequence)"/");
        return switch (count) {
            case 1 -> new SystemTopic(SystemTopicCategory.CLUSTER, "", topic);
            case 3 -> {
                String[] elements = StringUtils.split((String)topic, (String)"/");
                this.setNode(elements[2]);
                yield new SystemTopic(SystemTopicCategory.INFO, elements[3], topic);
            }
            default -> {
                String[] elements = StringUtils.split((String)topic, (String)"/", (int)5);
                yield new SystemTopic(SystemTopicCategory.valueOf(StringUtils.upperCase((String)elements[3])), elements[4], topic);
            }
        };
    }

    private void processStats(String category, Integer payload) {
        switch (category) {
            case "connections/count": {
                this.stats.setConnectionsCount(payload);
                break;
            }
            case "connections/max": {
                this.stats.setConnectionsMax(payload);
                break;
            }
            case "suboptions/count": {
                this.stats.setSubOptionsCount(payload);
                break;
            }
            case "suboptions/max": {
                this.stats.setSubOptionsMax(payload);
                break;
            }
            case "subscribers/count": {
                this.stats.setSubscribersCount(payload);
                break;
            }
            case "subscribers/max": {
                this.stats.setSubscribersMax(payload);
                break;
            }
            case "subscriptions/count": {
                this.stats.setSubscriptionsCount(payload);
                break;
            }
            case "subscriptions/max": {
                this.stats.setSubscriptionsMax(payload);
                break;
            }
            case "subscriptions/shared/count": {
                this.stats.setSubscriptionsSharedCount(payload);
                break;
            }
            case "subscriptions/shared/max": {
                this.stats.setSubscriptionsSharedMax(payload);
                break;
            }
            case "topics/count": {
                this.stats.setTopicsCount(payload);
                break;
            }
            case "topics/max": {
                this.stats.setTopicsMax(payload);
                break;
            }
            case "routes/count": {
                this.stats.setRoutesCount(payload);
                break;
            }
            case "routes/max": {
                this.stats.setRoutesMax(payload);
                break;
            }
        }
    }
}

