/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.transform.emqx.aggregator;

import cn.herodotus.stirrup.cache.caffeine.enhance.CaffeineNeverExpire;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import java.time.Instant;
import org.apache.commons.lang3.StringUtils;

public class MonitorAggregatingMessageCorrelationIdFactory {
    private static final String AGGREGATING_MESSAGE_CORRELATION_ID = "emqx_monitor_aggregating_correlation_id";
    private final Cache<String, String> cache = Caffeine.newBuilder().expireAfter((Expiry)new CaffeineNeverExpire()).build();

    private String readFromCache() {
        return (String)this.cache.getIfPresent((Object)AGGREGATING_MESSAGE_CORRELATION_ID);
    }

    private void writeToCache(String value) {
        this.cache.put((Object)AGGREGATING_MESSAGE_CORRELATION_ID, (Object)value);
    }

    private String create() {
        String correlationId = "STAMP-" + Instant.now().toEpochMilli();
        this.writeToCache(correlationId);
        return correlationId;
    }

    public boolean absent() {
        String correlationId = this.readFromCache();
        return StringUtils.isBlank((CharSequence)correlationId);
    }

    public String get() {
        String correlationId = this.readFromCache();
        if (StringUtils.isEmpty((CharSequence)correlationId)) {
            correlationId = this.create();
        }
        return correlationId;
    }

    public void erase() {
        this.cache.invalidate((Object)AGGREGATING_MESSAGE_CORRELATION_ID);
    }
}

