/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Cloud.
 *
 * Herodotus Cloud is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Cloud is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.transform.emqx.transformer;

import cn.herodotus.stirrup.core.foundation.json.jackson2.utils.Jackson2Utils;
import cn.herodotus.stirrup.core.event.domain.emqx.*;
import cn.herodotus.stirrup.core.event.event.emqx.*;
import org.springframework.context.ApplicationEvent;
import org.springframework.integration.transformer.AbstractPayloadTransformer;

import java.util.Map;

/**
 * <p>Description: TODO </p>
 *
 * @author : gengwei.zheng
 * @date : 2023/11/30 16:00
 */
public class WebhookMapToEventTransformer extends AbstractPayloadTransformer<Map<String, Object>, ApplicationEvent> {

    @Override
    protected ApplicationEvent transformPayload(Map<String, Object> payload) {
        Object event = payload.get("event");
        String type = String.valueOf(event);
        return process(type, payload);
    }

    /**
     * 将 Map 类型数据转换为指定类型的实体
     *
     * @param data      Map 类型数据
     * @param beanClass 实体类
     * @param <T>       实体类型
     * @return 指定的实体
     */
    private <T> T getBean(Map<String, Object> data, Class<T> beanClass) {
        return Jackson2Utils.toObject(data, beanClass);
    }

    private ApplicationEvent process(String type, Map<String, Object> data) {
        return switch (type) {
            case "client.connack" -> new WebhookClientConnectAckEvent(getBean(data, WebhookClientConnectAck.class));
            case "client.connected" -> new WebhookClientConnectedEvent(getBean(data, WebhookClientConnected.class));
            case "client.disconnected" ->
                    new WebhookClientDisconnectedEvent(getBean(data, WebhookClientDisconnected.class));
            case "message.acked" -> new WebhookMessageAckedEvent(getBean(data, WebhookMessageAcked.class));
            case "message.delivered" -> new WebhookMessageDeliveredEvent(getBean(data, WebhookMessageDelivered.class));
            case "message.dropped" -> new WebhookMessageDroppedEvent(getBean(data, WebhookMessageDropped.class));
            case "session.subscribed" ->
                    new WebhookSessionSubscribedEvent(getBean(data, WebhookSessionSubscribed.class));
            case "session.unsubscribed" ->
                    new WebhookSessionUnsubscribedEvent(getBean(data, WebhookSessionUnsubscribed.class));
            default ->
                    new WebhookClientCheckAuthenticationCompleteEvent(getBean(data, WebhookClientCheckAuthenticationComplete.class));
        };
    }
}
