/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Cloud.
 *
 * Herodotus Cloud is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Cloud is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.transform.emqx.properties;

import cn.herodotus.stirrup.transform.emqx.constants.TransformEmqxConstants;
import cn.herodotus.stirrup.transform.emqx.enums.EmqxEventSource;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * <p>Description: 物联网数据传输配置 </p>
 *
 * @author : gengwei.zheng
 * @date : 2023/12/6 10:31
 */
@ConfigurationProperties(prefix = TransformEmqxConstants.PROPERTY_TRANSFORM_EMQX)
public class TransformEmqxProperties {

    /**
     * Emqx 事件来源。
     */
    private EmqxEventSource emqxEventSource = EmqxEventSource.SYS_TOPIC;

    public EmqxEventSource getEmqxEventSource() {
        return emqxEventSource;
    }

    public void setEmqxEventSource(EmqxEventSource emqxEventSource) {
        this.emqxEventSource = emqxEventSource;
    }
}
