/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Cloud.
 *
 * Herodotus Cloud is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Cloud is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.transform.emqx.enums;

/**
 * <p>Description: Emqx 监控指标类型 </p>
 * <p>
 * 目前仅是根据 Emqx 官方文档进行了整理，如有缺少的内容后续再进行补充。
 * <a herf="https://www.emqx.io/docs/zh/latest/observability/mqtt-system-topics.html">文档地址</a>
 *
 * @author : gengwei.zheng
 * @date : 2023/11/13 20:28
 */
public enum SystemTopicCategory {
    /**
     * 仅代表Emqx集群状态信息中的 $SYS/brokers
     */
    CLUSTER,
    /**
     * Emqx集群状态信息中，除 $SYS/brokers以外的所有
     */
    INFO,
    /**
     * Emqx 客户端事件，包括：客户端上下线事件，客户端订阅与取消订阅事件
     */
    CLIENTS,
    /**
     * Emqx 系统统计类指标，包括：客户端统计，订阅统计，主题统计，路由统计
     */
    STATS,
    /**
     * Emqx 收发流量、报文、消息统计。包括：收发流量统计，MQTT 报文收发统计，MQTT 消息收发统计
     */
    METRICS,
    /**
     * Emqx 系统告警类指标
     */
    ALARMS,
    /**
     * Emqx 系统监控类指标
     */
    SYSMON;
}
