/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Cloud.
 *
 * Herodotus Cloud is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Cloud is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.transform.emqx.domain;

import cn.herodotus.stirrup.transform.emqx.enums.SystemTopicCategory;

/**
 * <p>Description: 系统主题对象 </p>
 *
 * @param systemTopicCategory 系统主题分类 {@link SystemTopicCategory}
 * @param topicName           系统主题名称。去除通用内容的用以区分主题的名称
 * @param topic               完整的系统主题
 * @author : gengwei.zheng
 * @date : 2023/11/13 20:48
 */
public record SystemTopic(SystemTopicCategory systemTopicCategory, String topicName, String topic) {
}
