/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Cloud.
 *
 * Herodotus Cloud is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Cloud is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.transform.emqx.domain;

import com.google.common.base.MoreObjects;
import com.influxdb.annotations.Column;
import com.influxdb.annotations.Measurement;

import java.time.Instant;

/**
 * <p>Description: Emqx 监控数据中 Stats 类别下的所有指标数据实体 </p>
 *
 * @author : gengwei.zheng
 * @date : 2023/11/11 8:59
 */
@Measurement(name = "emqx_stats")
public class StatsIndicator {

    @Column(tag = true)
    private String node;

    @Column(tag = true)
    private String version;

    @Column(timestamp = true)
    private Instant time;

    /**
     * 当前客户端总数
     */
    @Column
    private Integer connectionsCount = 0;
    /**
     * 客户端数量历史最大值
     */
    @Column
    private Integer connectionsMax = 0;
    /**
     * 当前订阅选项个数
     */
    @Column
    private Integer subOptionsCount = 0;
    /**
     * 订阅选项总数历史最大值
     */
    @Column
    private Integer subOptionsMax = 0;
    /**
     * 当前订阅者数量
     */
    @Column
    private Integer subscribersCount = 0;
    /**
     * 订阅者总数历史最大值
     */
    @Column
    private Integer subscribersMax = 0;
    /**
     * 当前订阅总数
     */
    @Column
    private Integer subscriptionsCount = 0;
    /**
     * 订阅数量历史最大值
     */
    @Column
    private Integer subscriptionsMax = 0;
    /**
     * 当前共享订阅个数
     */
    @Column
    private Integer subscriptionsSharedCount = 0;
    /**
     * 当前共享订阅总数
     */
    @Column
    private Integer subscriptionsSharedMax = 0;
    /**
     * 当前 Topic 总数
     */
    @Column
    private Integer topicsCount = 0;
    /**
     * Topic 数量历史最大值
     */
    @Column
    private Integer topicsMax = 0;
    /**
     * 当前 Routes 总数
     */
    @Column
    private Integer routesCount = 0;
    /**
     * Routes 数量历史最大值
     */
    @Column
    private Integer routesMax = 0;

    public String getNode() {
        return node;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Instant getTime() {
        return time;
    }

    public void setTime(Instant time) {
        this.time = time;
    }

    public Integer getConnectionsCount() {
        return connectionsCount;
    }

    public void setConnectionsCount(Integer connectionsCount) {
        this.connectionsCount = connectionsCount;
    }

    public Integer getConnectionsMax() {
        return connectionsMax;
    }

    public void setConnectionsMax(Integer connectionsMax) {
        this.connectionsMax = connectionsMax;
    }

    public Integer getSubOptionsCount() {
        return subOptionsCount;
    }

    public void setSubOptionsCount(Integer subOptionsCount) {
        this.subOptionsCount = subOptionsCount;
    }

    public Integer getSubOptionsMax() {
        return subOptionsMax;
    }

    public void setSubOptionsMax(Integer subOptionsMax) {
        this.subOptionsMax = subOptionsMax;
    }

    public Integer getSubscribersCount() {
        return subscribersCount;
    }

    public void setSubscribersCount(Integer subscribersCount) {
        this.subscribersCount = subscribersCount;
    }

    public Integer getSubscribersMax() {
        return subscribersMax;
    }

    public void setSubscribersMax(Integer subscribersMax) {
        this.subscribersMax = subscribersMax;
    }

    public Integer getSubscriptionsCount() {
        return subscriptionsCount;
    }

    public void setSubscriptionsCount(Integer subscriptionsCount) {
        this.subscriptionsCount = subscriptionsCount;
    }

    public Integer getSubscriptionsMax() {
        return subscriptionsMax;
    }

    public void setSubscriptionsMax(Integer subscriptionsMax) {
        this.subscriptionsMax = subscriptionsMax;
    }

    public Integer getSubscriptionsSharedCount() {
        return subscriptionsSharedCount;
    }

    public void setSubscriptionsSharedCount(Integer subscriptionsSharedCount) {
        this.subscriptionsSharedCount = subscriptionsSharedCount;
    }

    public Integer getSubscriptionsSharedMax() {
        return subscriptionsSharedMax;
    }

    public void setSubscriptionsSharedMax(Integer subscriptionsSharedMax) {
        this.subscriptionsSharedMax = subscriptionsSharedMax;
    }

    public Integer getTopicsCount() {
        return topicsCount;
    }

    public void setTopicsCount(Integer topicsCount) {
        this.topicsCount = topicsCount;
    }

    public Integer getTopicsMax() {
        return topicsMax;
    }

    public void setTopicsMax(Integer topicsMax) {
        this.topicsMax = topicsMax;
    }

    public Integer getRoutesCount() {
        return routesCount;
    }

    public void setRoutesCount(Integer routesCount) {
        this.routesCount = routesCount;
    }

    public Integer getRoutesMax() {
        return routesMax;
    }

    public void setRoutesMax(Integer routesMax) {
        this.routesMax = routesMax;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("node", node)
                .add("version", version)
                .add("time", time)
                .add("connectionsCount", connectionsCount)
                .add("connectionsMax", connectionsMax)
                .add("subOptionsCount", subOptionsCount)
                .add("subOptionsMax", subOptionsMax)
                .add("subscribersCount", subscribersCount)
                .add("subscribersMax", subscribersMax)
                .add("subscriptionsCount", subscriptionsCount)
                .add("subscriptionsMax", subscriptionsMax)
                .add("subscriptionsSharedCount", subscriptionsSharedCount)
                .add("subscriptionsSharedMax", subscriptionsSharedMax)
                .add("topicsCount", topicsCount)
                .add("topicsMax", topicsMax)
                .add("routesCount", routesCount)
                .add("routesMax", routesMax)
                .toString();
    }
}
