/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Cloud.
 *
 * Herodotus Cloud is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Cloud is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.transform.emqx.converter;

import cn.herodotus.stirrup.transform.emqx.domain.StatsIndicator;

/**
 * <p>Description: Message Payload 转 Emqx 统计指标转换器  </p>
 *
 * @author : gengwei.zheng
 * @date : 2023/11/22 22:22
 */
public class EmqxStatsIndicatorConverter implements Influxdb2Converter<StatsIndicator> {
    @Override
    public StatsIndicator convert(Object source) {
        if (source instanceof StatsIndicator statsIndicator) {
            return statsIndicator;
        } else {
            return new StatsIndicator();
        }
    }
}
