/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Cloud.
 *
 * Herodotus Cloud is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Cloud is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.transform.emqx.config;

import cn.herodotus.stirrup.transform.emqx.properties.TransformEmqxProperties;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

/**
 * <p>Description: Iot 数据集成传输配置 </p>
 *
 * @author : gengwei.zheng
 * @date : 2023/10/19 16:25
 */
@Configuration(proxyBeanMethods = false)
@EnableConfigurationProperties(TransformEmqxProperties.class)
@ComponentScan(basePackages = {
        "cn.herodotus.stirrup.transform.emqx.storage",
})
@Import({
        EmqxSystemClientToEventFlowConfiguration.class,
        EmqxWebhookToEventFlowConfiguration.class
})
public class TransformEmqxConfiguration {

    private static final Logger log = LoggerFactory.getLogger(TransformEmqxConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- SDK [Iot Transfer] Auto Configure.");
    }
}
