/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Cloud.
 *
 * Herodotus Cloud is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Cloud is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.transform.emqx.condition;

import cn.herodotus.stirrup.core.foundation.context.PropertyResolver;
import cn.herodotus.stirrup.transform.emqx.constants.TransformEmqxConstants;
import cn.herodotus.stirrup.transform.emqx.enums.EmqxEventSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

/**
 * <p>Description: Emqx 系统主题事件条件 </p>
 *
 * @author : gengwei.zheng
 * @date : 2023/12/6 10:50
 */
public class EmqxSystemTopicEventCondition implements Condition {

    private static final Logger log = LoggerFactory.getLogger(EmqxSystemTopicEventCondition.class);

    @SuppressWarnings("NullableProblems")
    @Override
    public boolean matches(ConditionContext conditionContext, AnnotatedTypeMetadata annotatedTypeMetadata) {
        String property = PropertyResolver.getProperty(conditionContext, TransformEmqxConstants.ITEM_TRANSFER_EMQX_EVENT_SOURCE, EmqxEventSource.SYS_TOPIC.name());
        boolean result = StringUtils.isNotBlank(property) && StringUtils.equalsIgnoreCase(property, EmqxEventSource.SYS_TOPIC.name());
        log.debug("[Herodotus] |- Condition [Emqx Sys Topic Event] value is [{}]", result);
        return result;
    }
}
