/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Cloud.
 *
 * Herodotus Cloud is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Cloud is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.transform.emqx.aggregator;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.integration.aggregator.ReleaseStrategy;
import org.springframework.integration.store.MessageGroup;
import org.springframework.messaging.Message;

import java.util.Collection;

/**
 * <p>Description: Emqx 监控消息聚合释放标记 </p>
 *
 * @author : gengwei.zheng
 * @date : 2023/11/11 17:42
 */
public class MonitorAggregatingMessageReleaseStrategy implements ReleaseStrategy {

    private final MonitorAggregatingMessageCorrelationIdFactory correlationIdFactory;

    public MonitorAggregatingMessageReleaseStrategy(MonitorAggregatingMessageCorrelationIdFactory correlationIdFactory) {
        this.correlationIdFactory = correlationIdFactory;
    }

    @Override
    public boolean canRelease(MessageGroup group) {
        Collection<Message<?>> messages = group.getMessages();
        return CollectionUtils.isNotEmpty(messages) && correlationIdFactory.absent();
    }
}
