/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.servlet.message.autoconfigure;

import cn.herodotus.stirrup.core.definition.function.ErrorCodeMapperBuilderCustomizer;
import cn.herodotus.stirrup.message.core.customizer.MessageErrorCodeMapperBuilderCustomizer;
import cn.herodotus.stirrup.message.mqtt.annotation.EnableHerodotusMqtt;
import cn.herodotus.stirrup.message.websocket.servlet.annotation.EnableHerodotusServletWebSocket;
import cn.herodotus.stirrup.rest.servlet.message.annotation.EnableHerodotusRestServletMessage;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.annotation.Bean;

/**
 * <p>Description: Servlet Message 自动配置 </p>
 *
 * @author : gengwei.zheng
 * @date : 2024/4/10 0:31
 */
@AutoConfiguration
@EnableHerodotusServletWebSocket
@EnableHerodotusMqtt
@EnableHerodotusRestServletMessage
public class ServletMessageAutoConfiguration {

    private static final Logger log = LoggerFactory.getLogger(ServletMessageAutoConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.info("[Herodotus] |- Starter [Servlet Message] Configure.");
    }

    @Bean
    public ErrorCodeMapperBuilderCustomizer messageErrorCodeMapperBuilderCustomizer() {
        MessageErrorCodeMapperBuilderCustomizer customizer = new MessageErrorCodeMapperBuilderCustomizer();
        log.debug("[Herodotus] |- Strategy [Message ErrorCodeMapper Builder Customizer] Configure.");
        return customizer;
    }
}
