/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.servlet.container.autoconfigure.customizer;

import io.undertow.connector.ByteBufferPool;
import io.undertow.server.DefaultByteBufferPool;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.embedded.undertow.UndertowDeploymentInfoCustomizer;
import org.springframework.boot.web.embedded.undertow.UndertowServletWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class UndertowWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<UndertowServletWebServerFactory> {
    private static final Logger log = LoggerFactory.getLogger(UndertowWebServerFactoryCustomizer.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- Module [Undertow WebServer Factory Customizer] Configure.");
    }

    public void customize(UndertowServletWebServerFactory factory) {
        factory.addDeploymentInfoCustomizers(new UndertowDeploymentInfoCustomizer[]{deploymentInfo -> {
            WebSocketDeploymentInfo webSocketDeploymentInfo = new WebSocketDeploymentInfo();
            webSocketDeploymentInfo.setBuffers((ByteBufferPool)new DefaultByteBufferPool(false, 1024));
            deploymentInfo.addServletContextAttribute("io.undertow.websockets.jsr.WebSocketDeploymentInfo", (Object)webSocketDeploymentInfo);
        }});
    }
}

