/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.rest.servlet.device.controller;

import cn.herodotus.stirrup.logic.iot.device.entity.IotDeviceTopic;
import cn.herodotus.stirrup.logic.iot.device.service.IotDeviceTopicService;
import cn.herodotus.stirrup.data.crud.service.JpaWriteableService;
import cn.herodotus.stirrup.web.api.servlet.AbstractJpaWriteableController;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>Description: 物联网设备主题管理接口 </p>
 *
 * @author : gengwei.zheng
 * @date : 2023/10/11 22:01
 */
@RestController
@RequestMapping("/iot/device/topic")
@Tags({
        @Tag(name = "物联网设备管理接口"),
        @Tag(name = "物联网设备主题管理接口"),
})
public class IotDeviceTopicController extends AbstractJpaWriteableController<IotDeviceTopic, String> {

    private final IotDeviceTopicService iotDeviceTopicService;

    public IotDeviceTopicController(IotDeviceTopicService iotDeviceTopicService) {
        this.iotDeviceTopicService = iotDeviceTopicService;
    }

    @Override
    public JpaWriteableService<IotDeviceTopic, String> getWriteableService() {
        return this.iotDeviceTopicService;
    }
}
