/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.rest.servlet.device.controller;

import cn.herodotus.stirrup.data.crud.service.JpaWriteableService;
import cn.herodotus.stirrup.logic.iot.device.entity.IotDeviceAcl;
import cn.herodotus.stirrup.logic.iot.device.generator.IotDeviceAclId;
import cn.herodotus.stirrup.logic.iot.device.service.IotDeviceAclService;
import cn.herodotus.stirrup.web.api.servlet.AbstractJpaWriteableController;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>Description: 物联网设备授权管理接口 </p>
 *
 * @author : gengwei.zheng
 * @date : 2023/10/11 21:58
 */
@RestController
@RequestMapping("/iot/device/acl")
@Tags({
        @Tag(name = "物联网设备管理接口"),
        @Tag(name = "物联网设备授权管理接口"),
})
public class IotDeviceAclController extends AbstractJpaWriteableController<IotDeviceAcl, IotDeviceAclId> {

    private final IotDeviceAclService iotDeviceAclService;

    public IotDeviceAclController(IotDeviceAclService iotDeviceAclService) {
        this.iotDeviceAclService = iotDeviceAclService;
    }


    @Override
    public JpaWriteableService<IotDeviceAcl, IotDeviceAclId> getWriteableService() {
        return this.iotDeviceAclService;
    }
}
