/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.rest.servlet.device.controller;

import cn.herodotus.stirrup.core.definition.domain.Result;
import cn.herodotus.stirrup.core.definition.domain.base.Entity;
import cn.herodotus.stirrup.data.crud.service.JpaWriteableService;
import cn.herodotus.stirrup.logic.iot.device.entity.IotDeviceDetails;
import cn.herodotus.stirrup.logic.iot.device.service.IotDeviceDetailsService;
import cn.herodotus.stirrup.web.api.servlet.AbstractJpaWriteableController;
import cn.herodotus.stirrup.web.core.annotation.AccessLimited;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import jakarta.validation.constraints.NotNull;
import java.util.Map;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/iot/device/details"})
@Tags(value={@Tag(name="\u7269\u8054\u7f51\u8bbe\u5907\u7ba1\u7406\u63a5\u53e3"), @Tag(name="\u7269\u8054\u7f51\u8bbe\u5907\u8be6\u60c5\u7ba1\u7406\u63a5\u53e3")})
public class IotDeviceDetailsController
extends AbstractJpaWriteableController<IotDeviceDetails, String> {
    private final IotDeviceDetailsService iotDeviceDetailsService;

    public IotDeviceDetailsController(IotDeviceDetailsService iotDeviceDetailsService) {
        this.iotDeviceDetailsService = iotDeviceDetailsService;
    }

    public JpaWriteableService<IotDeviceDetails, String> getWriteableService() {
        return this.iotDeviceDetailsService;
    }

    @AccessLimited
    @Operation(summary="\u6761\u4ef6\u5206\u9875\u67e5\u8be2\u8bbe\u5907\u8be6\u60c5", description="\u6839\u636e\u52a8\u6001\u8f93\u5165\u7684\u5b57\u6bb5\u67e5\u8be2\u8bbe\u5907\u8be6\u60c5\u5206\u9875\u4fe1\u606f", responses={@ApiResponse(description="\u8bbe\u5907\u8be6\u60c5\u5217\u8868", content={@Content(mediaType="application/json", schema=@Schema(implementation=Map.class))})})
    @Parameters(value={@Parameter(name="pageNumber", required=true, in=ParameterIn.QUERY, description="\u5f53\u524d\u9875\u7801"), @Parameter(name="pageSize", required=true, in=ParameterIn.QUERY, description="\u6bcf\u9875\u663e\u793a\u6570\u91cf"), @Parameter(name="productKey", in=ParameterIn.QUERY, description="\u6bcf\u4e2a\u4ea7\u54c1\u9881\u53d1\u5168\u5c40\u552f\u4e00\u7684ProductKey")})
    @GetMapping(value={"/list"})
    public Result<Map<String, Object>> findByCondition(@NotNull @RequestParam(value="pageNumber") Integer pageNumber, @NotNull @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="productKey", required=false) String productKey) {
        Page pages = this.iotDeviceDetailsService.findByCondition(pageNumber.intValue(), pageSize.intValue(), productKey);
        return this.result(pages);
    }

    @AccessLimited
    @Operation(summary="\u6761\u4ef6\u5206\u9875\u67e5\u8be2\u8bbe\u5907\u8be6\u60c5", description="\u6839\u636e\u52a8\u6001\u8f93\u5165\u7684\u5b57\u6bb5\u67e5\u8be2\u8bbe\u5907\u8be6\u60c5\u5206\u9875\u4fe1\u606f", responses={@ApiResponse(description="\u8bbe\u5907\u8be6\u60c5\u5217\u8868", content={@Content(mediaType="application/json", schema=@Schema(implementation=IotDeviceDetails.class))})})
    @Parameters(value={@Parameter(name="productKey", required=true, in=ParameterIn.QUERY, description="\u6bcf\u4e2a\u4ea7\u54c1\u9881\u53d1\u5168\u5c40\u552f\u4e00\u7684ProductKey"), @Parameter(name="deviceName", required=true, in=ParameterIn.QUERY, description="\u4ea7\u54c1\u5185\u552f\u4e00\u7684\u8bc1\u4e66 DeviceName")})
    @GetMapping(value={"/one"})
    public Result<IotDeviceDetails> findOne(@NotNull @RequestParam(value="productKey") String productKey, @NotNull @RequestParam(value="deviceName") String deviceName) {
        IotDeviceDetails domain = this.iotDeviceDetailsService.findByProductKeyAndDeviceName(productKey, deviceName);
        return this.result((Entity)domain);
    }
}

