/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2020-2030 ZHENGGENGWEI<码匠君>. All rights reserved.
 *
 *    Author: ZHENGGENGWEI<码匠君>
 *    Contact: <herodotus@aliyun.com>
 *    Blog and source code availability: <https://gitee.com/herodotus/herodotus-cloud>
 */

package cn.herodotus.stirrup.rest.servlet.device.controller;

import cn.herodotus.stirrup.logic.iot.device.entity.IotDeviceTopic;
import cn.herodotus.stirrup.logic.iot.device.service.IotDeviceTopicService;
import cn.herodotus.stirrup.data.crud.service.JpaWriteableService;
import cn.herodotus.stirrup.web.api.servlet.AbstractJpaWriteableController;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>Description: 物联网设备主题管理接口 </p>
 *
 * @author : gengwei.zheng
 * @date : 2023/10/11 22:01
 */
@RestController
@RequestMapping("/iot/device/topic")
@Tags({
        @Tag(name = "物联网设备管理接口"),
        @Tag(name = "物联网设备主题管理接口"),
})
public class IotDeviceTopicController extends AbstractJpaWriteableController<IotDeviceTopic, String> {

    private final IotDeviceTopicService iotDeviceTopicService;

    public IotDeviceTopicController(IotDeviceTopicService iotDeviceTopicService) {
        this.iotDeviceTopicService = iotDeviceTopicService;
    }

    @Override
    public JpaWriteableService<IotDeviceTopic, String> getWriteableService() {
        return this.iotDeviceTopicService;
    }
}
