/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2020-2030 ZHENGGENGWEI<码匠君>. All rights reserved.
 *
 *    Author: ZHENGGENGWEI<码匠君>
 *    Contact: <herodotus@aliyun.com>
 *    Blog and source code availability: <https://gitee.com/herodotus/herodotus-cloud>
 */

package cn.herodotus.stirrup.rest.servlet.device.controller;

import cn.herodotus.stirrup.data.crud.service.JpaWriteableService;
import cn.herodotus.stirrup.logic.iot.device.entity.IotDeviceAcl;
import cn.herodotus.stirrup.logic.iot.device.generator.IotDeviceAclId;
import cn.herodotus.stirrup.logic.iot.device.service.IotDeviceAclService;
import cn.herodotus.stirrup.web.api.servlet.AbstractJpaWriteableController;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>Description: 物联网设备授权管理接口 </p>
 *
 * @author : gengwei.zheng
 * @date : 2023/10/11 21:58
 */
@RestController
@RequestMapping("/iot/device/acl")
@Tags({
        @Tag(name = "物联网设备管理接口"),
        @Tag(name = "物联网设备授权管理接口"),
})
public class IotDeviceAclController extends AbstractJpaWriteableController<IotDeviceAcl, IotDeviceAclId> {

    private final IotDeviceAclService iotDeviceAclService;

    public IotDeviceAclController(IotDeviceAclService iotDeviceAclService) {
        this.iotDeviceAclService = iotDeviceAclService;
    }


    @Override
    public JpaWriteableService<IotDeviceAcl, IotDeviceAclId> getWriteableService() {
        return this.iotDeviceAclService;
    }
}
