/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Cloud.
 *
 * Herodotus Cloud is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Cloud is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.rest.reactive.message.controller;

import cn.herodotus.stirrup.core.definition.domain.Result;
import cn.herodotus.stirrup.data.crud.service.JpaWriteableService;
import cn.herodotus.stirrup.logic.message.entity.DialogueContact;
import cn.herodotus.stirrup.logic.message.service.DialogueContactService;
import cn.herodotus.stirrup.web.api.reactive.AbstractJpaWriteableController;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.tags.Tags;
import jakarta.validation.constraints.NotNull;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

import java.util.Map;

/**
 * <p>Description: DialogueContactController </p>
 *
 * @author : gengwei.zheng
 * @date : 2022/12/17 0:05
 */
@RestController
@RequestMapping("/message/dialogue/contact")
@Tags({
        @Tag(name = "消息管理接口"),
        @Tag(name = "私信管理接口"),
        @Tag(name = "私信联系人管理接口")
})
public class DialogueContactController extends AbstractJpaWriteableController<DialogueContact, String> {

    private final DialogueContactService dialogueContactService;

    public DialogueContactController(DialogueContactService dialogueContactService) {
        this.dialogueContactService = dialogueContactService;
    }

    @Override
    public JpaWriteableService<DialogueContact, String> getWriteableService() {
        return dialogueContactService;
    }

    @Operation(summary = "条件查询私信联系人分页数据", description = "根据输入的字段条件查询联系人信息",
            responses = {@ApiResponse(description = "联系人列表", content = @Content(mediaType = "application/json", schema = @Schema(implementation = Map.class)))})
    @Parameters({
            @Parameter(name = "pageNumber", required = true, description = "当前页码", schema = @Schema(type = "integer")),
            @Parameter(name = "pageSize", required = true, description = "每页显示数量", schema = @Schema(type = "integer")),
            @Parameter(name = "receiverId", required = true, description = "收信人ID，即当前用户ID"),
    })
    @GetMapping("/condition")
    public Mono<Result<Map<String, Object>>> findByCondition(@NotNull @RequestParam("pageNumber") Integer pageNumber,
                                                             @NotNull @RequestParam("pageSize") Integer pageSize,
                                                             @NotNull @RequestParam("receiverId") String receiverId) {
        Page<DialogueContact> pages = dialogueContactService.findByCondition(pageNumber, pageSize, receiverId);
        return result(pages);
    }
}
