/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.openapi.polaris.service;

import cn.herodotus.stirrup.openapi.polaris.core.PolarisRestApiTemplate;
import cn.herodotus.stirrup.openapi.polaris.domain.base.Response;
import cn.herodotus.stirrup.openapi.polaris.domain.request.UserPasswordUpdateRequest;
import cn.herodotus.stirrup.openapi.polaris.domain.request.UserUpdateRequest;
import cn.zhxu.data.TypeRef;
import cn.zhxu.okhttps.HttpResult;
import cn.zhxu.okhttps.SHttpTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserService {
    private static final Logger log = LoggerFactory.getLogger(UserService.class);
    private final PolarisRestApiTemplate polarisRestApiTemplate;

    public UserService(PolarisRestApiTemplate polarisRestApiTemplate) {
        this.polarisRestApiTemplate = polarisRestApiTemplate;
    }

    public boolean update(UserUpdateRequest request) {
        HttpResult result = ((SHttpTask)((SHttpTask)((SHttpTask)this.polarisRestApiTemplate.sync("/core/v1/user").bodyType("json")).addBodyPara(request.getParams())).nothrow()).put();
        if (result.isSuccessful()) {
            return true;
        }
        log.error("[Herodotus] |- Polaris user update catch error!", (Throwable)result.getError());
        return false;
    }

    public boolean updatePassword(UserPasswordUpdateRequest request) {
        HttpResult result = ((SHttpTask)((SHttpTask)((SHttpTask)this.polarisRestApiTemplate.sync("/core/v1/user/password").bodyType("json")).addBodyPara(request.getParams())).nothrow()).put();
        if (result.isSuccessful()) {
            return true;
        }
        log.error("[Herodotus] |- Polaris user password update catch error!", (Throwable)result.getError());
        return false;
    }

    public Response token(String id) {
        HttpResult result = ((SHttpTask)((SHttpTask)((SHttpTask)this.polarisRestApiTemplate.sync("/core/v1/user/token").bodyType("json")).addUrlPara("id", (Object)id)).nothrow()).get();
        if (result.isSuccessful()) {
            return (Response)result.getBody().toBean((TypeRef)new TypeRef<Response>(this){});
        }
        log.error("[Herodotus] |- Polaris get user token catch error!", (Throwable)result.getError());
        return null;
    }
}

