/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.openapi.polaris.core;

import cn.herodotus.stirrup.core.definition.support.RestApiTemplate;
import cn.herodotus.stirrup.openapi.polaris.cache.AuthenticationCache;
import cn.herodotus.stirrup.openapi.polaris.domain.base.Response;
import cn.zhxu.data.TypeRef;
import cn.zhxu.okhttps.HttpResult;
import cn.zhxu.okhttps.SHttpTask;
import java.time.Duration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolarisRestApiTemplate
implements RestApiTemplate {
    private static final Logger log = LoggerFactory.getLogger(PolarisRestApiTemplate.class);
    private final String endpoint;
    private final String username;
    private final String password;
    private final AuthenticationCache authenticationCache;

    public PolarisRestApiTemplate(String endpoint, String username, String password, Duration tokenTtl) {
        this.endpoint = endpoint;
        this.username = username;
        this.password = password;
        this.authenticationCache = new AuthenticationCache(tokenTtl);
    }

    public String getUrl() {
        return this.endpoint;
    }

    public void login() {
        HttpResult result = ((SHttpTask)((SHttpTask)((SHttpTask)((SHttpTask)this.http().sync("/core/v1/user/login").bodyType("json")).addBodyPara("name", (Object)this.username)).addBodyPara("password", (Object)this.password)).nothrow()).post();
        if (result.isSuccessful()) {
            Response response = (Response)result.getBody().toBean((TypeRef)new TypeRef<Response>(this){});
            this.authenticationCache.setToken(response.getLoginResponse().getToken());
            this.authenticationCache.setUserId(response.getLoginResponse().getUserId());
            log.info("[Herodotus] |- Polaris server login successful.");
        } else {
            log.error("[Herodotus] |- Polaris server login failed.", (Throwable)result.getError());
        }
    }

    public SHttpTask sync(String api) {
        String token = this.authenticationCache.getToken();
        if (StringUtils.isBlank((CharSequence)token)) {
            this.login();
        }
        return (SHttpTask)this.http().sync(api).addHeader("X-Polaris-Token", this.authenticationCache.getToken());
    }
}

