/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.openapi.polaris.config;

import cn.herodotus.stirrup.openapi.polaris.annotation.ConditionalOnPolarisConfigured;
import cn.herodotus.stirrup.openapi.polaris.core.PolarisRestApiTemplate;
import cn.herodotus.stirrup.openapi.polaris.properties.PolarisProperties;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnPolarisConfigured
@EnableConfigurationProperties(value={PolarisProperties.class})
@ComponentScan(basePackages={"cn.herodotus.stirrup.openapi.polaris.service", "cn.herodotus.stirrup.openapi.polaris.controller"})
public class PolarisConfiguration {
    private static final Logger log = LoggerFactory.getLogger(PolarisConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- Module [Polaris REST API] Auto Configure.");
    }

    @Bean
    @ConditionalOnMissingBean
    public PolarisRestApiTemplate polarisRestApiTemplate(PolarisProperties polarisProperties) {
        PolarisRestApiTemplate template = new PolarisRestApiTemplate(polarisProperties.getEndpoint(), polarisProperties.getUsername(), polarisProperties.getPassword(), polarisProperties.getTokenTtl());
        log.trace("[Herodotus] |- Bean [Polaris Rest Api Template] Auto Configure.");
        return template;
    }
}

