/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.openapi.emqx.core;

import cn.herodotus.stirrup.openapi.core.definition.AbstractWebClientTemplate;
import cn.herodotus.stirrup.openapi.emqx.domain.response.EmqxResponse;
import cn.herodotus.stirrup.openapi.emqx.properties.EmqxProperties;
import java.util.function.Function;
import okhttp3.Credentials;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class EmqxTemplate
extends AbstractWebClientTemplate {
    private static final Logger log = LoggerFactory.getLogger(EmqxTemplate.class);
    private final EmqxProperties emqxProperties;

    public EmqxTemplate(WebClient webClient, EmqxProperties emqxProperties) {
        super(webClient);
        this.emqxProperties = emqxProperties;
    }

    protected Function<ClientRequest, Mono<ClientRequest>> authentication() {
        return clientRequest -> {
            ClientRequest request = ClientRequest.from((ClientRequest)clientRequest).header("Content-Type", new String[]{"application/json"}).header("Authorization", new String[]{Credentials.basic((String)this.emqxProperties.getApiKey(), (String)this.emqxProperties.getSecretKey())}).build();
            return Mono.just((Object)request);
        };
    }

    protected String getBaseUrl() {
        Object server = this.emqxProperties.getUrl();
        if (!StringUtils.endsWith((CharSequence)server, (CharSequence)"/")) {
            server = (String)server + "/";
        }
        String url = (String)server + "api/" + this.emqxProperties.getVersion() + "/nodes";
        log.debug("[Herodotus] |- Emqx open api address is [{}]!", (Object)url);
        return url;
    }

    public <O> Function<WebClientResponseException, Mono<O>> onErrorResume() {
        return exception -> {
            HttpRequest request = exception.getRequest();
            String path = request.getURI().getPath();
            HttpMethod method = request.getMethod();
            EmqxResponse response = (EmqxResponse)exception.getResponseBodyAs(EmqxResponse.class);
            log.error("[Herodotus] |- Invoke nacos open api [{} - {}] failure. Reason is [{}]", new Object[]{method.name(), path, response.getMessage()});
            EmqxResponse result = response;
            return Mono.just((Object)result);
        };
    }
}

