/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.openapi.emqx.config;

import cn.herodotus.stirrup.openapi.emqx.annotation.ConditionalOnEmqxEnabled;
import cn.herodotus.stirrup.openapi.emqx.core.EmqxTemplate;
import cn.herodotus.stirrup.openapi.emqx.properties.EmqxProperties;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration(proxyBeanMethods=false)
@ConditionalOnEmqxEnabled
@EnableConfigurationProperties(value={EmqxProperties.class})
@ComponentScan(basePackages={"cn.herodotus.stirrup.openapi.emqx.service"})
public class OpenApiEmqxConfiguration {
    private static final Logger log = LoggerFactory.getLogger(OpenApiEmqxConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- Module [Open API Emqx] Auto Configure.");
    }

    @Bean
    @ConditionalOnMissingBean
    public EmqxTemplate emqxTemplate(WebClient webClient, EmqxProperties emqxProperties) {
        EmqxTemplate template = new EmqxTemplate(webClient, emqxProperties);
        log.trace("[Herodotus] |- Bean [Emqx Template] Auto Configure.");
        return template;
    }
}

