/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Cloud.
 *
 * Herodotus Cloud is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Cloud is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.openapi.emqx.service;

import cn.herodotus.stirrup.openapi.emqx.constants.EmqxApis;
import cn.herodotus.stirrup.openapi.emqx.core.EmqxTemplate;
import cn.herodotus.stirrup.openapi.emqx.domain.response.EmqxResponse;
import com.google.common.collect.ImmutableMap;
import org.dromara.hutool.core.text.StrUtil;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

import java.util.Map;

/**
 * <p>Description: Emqx Client Rest API 封装 Service </p>
 *
 * @author : gengwei.zheng
 * @date : 2023/9/24 21:30
 */
@Service
public class ClientsService {

    private final EmqxTemplate emqxTemplate;

    public ClientsService(EmqxTemplate emqxTemplate) {
        this.emqxTemplate = emqxTemplate;
    }

    private String getClientKickOutUrl(String clientId) {
        Map<String, String> formatter = ImmutableMap.of("clientId", clientId);
        return StrUtil.format(EmqxApis.API_CLIENTS_KICK_OUT, formatter);
    }

    public Mono<EmqxResponse<Boolean>> delete(String clientId) {
        return emqxTemplate.deleteWithPathVariables(EmqxApis.API_CLIENTS_KICK_OUT, "clientId", clientId);
    }
}
