/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Cloud.
 *
 * Herodotus Cloud is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Cloud is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.openapi.emqx.properties;

import cn.herodotus.stirrup.openapi.core.constants.OpenApiConstants;
import com.google.common.base.MoreObjects;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * <p>Description: Emqx Rest API 管理模块配置参数 </p>
 *
 * @author : gengwei.zheng
 * @date : 2023/9/20 17:32
 */
@ConfigurationProperties(prefix = OpenApiConstants.PROPERTY_OPENAPI_EMQX)
public class EmqxProperties {

    /**
     * Emqx 服务器地址。默认为：http://localhost:18083
     */
    private String url = "http://localhost:18083";
    /**
     * Emqx Open API 秘钥中的 apiKey
     */
    private String apiKey;
    /**
     * Emqx Open API 秘钥中的 secretKey
     */
    private String secretKey;
    /**
     * Emqx Open API 版本，默认为 v5
     */
    private String version = "v5";

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getApiKey() {
        return apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getSecretKey() {
        return secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("url", url)
                .add("apiKey", apiKey)
                .add("secretKey", secretKey)
                .add("version", version)
                .toString();
    }
}
