/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Cloud.
 *
 * Herodotus Cloud is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Cloud is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.openapi.emqx.domain.request;

import cn.herodotus.stirrup.openapi.core.definition.AbstractRequest;
import cn.herodotus.stirrup.openapi.emqx.enums.PayloadEncoding;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;

/**
 * <p>Description: 发布消息请求参数实体 </p>
 *
 * @author : gengwei.zheng
 * @date : 2023/9/20 18:32
 */
public class PublishRequest extends AbstractRequest {

    @Schema(name = "MQTT 消息体的编码方式", description = "可以是 base64 或 plain。当设置为 base64 时，消息在发布前会先被解码", defaultValue = "plain")
    @JsonProperty("payload_encoding")
    private PayloadEncoding payloadEncoding = PayloadEncoding.plain;

    @Schema(name = "主题名称", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotBlank(message = "主题不能为空")
    private String topic;

    @Schema(name = "主题名称", defaultValue = "0")
    @Max(value = 2, message = "QOS 值设置错误")
    @Min(value = 0, message = "QOS 值设置错误")
    private Integer qos = 0;

    @Schema(name = "MQTT 消息体", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotBlank(message = "消息体不能为空")
    private String payload;

    private PublicProperties properties;

    @Schema(name = "是否保留消息", defaultValue = "false")
    private Boolean retain = false;

    public PayloadEncoding getPayloadEncoding() {
        return payloadEncoding;
    }

    public void setPayloadEncoding(PayloadEncoding payloadEncoding) {
        this.payloadEncoding = payloadEncoding;
    }

    public String getTopic() {
        return topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public Integer getQos() {
        return qos;
    }

    public void setQos(Integer qos) {
        this.qos = qos;
    }

    public String getPayload() {
        return payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public PublicProperties getProperties() {
        return properties;
    }

    public void setProperties(PublicProperties properties) {
        this.properties = properties;
    }

    public Boolean getRetain() {
        return retain;
    }

    public void setRetain(Boolean retain) {
        this.retain = retain;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("payloadEncoding", payloadEncoding)
                .add("topic", topic)
                .add("qos", qos)
                .add("payload", payload)
                .add("properties", properties)
                .add("retain", retain)
                .toString();
    }
}
