/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Cloud.
 *
 * Herodotus Cloud is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Cloud is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.openapi.emqx.domain.request;

import cn.herodotus.stirrup.openapi.core.definition.AbstractRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

import java.util.Map;

/**
 * <p>Description: Emqx 发布消息 Properties 参数对应实体 </p>
 *
 * @author : gengwei.zheng
 * @date : 2023/10/9 22:41
 */
public class PublicProperties extends AbstractRequest {

    @Schema(name = "载荷格式指示标识符", description = "0 表示载荷是未指定格式的数据，相当于没有发送载荷格式指示；1 表示载荷是 UTF-8 编码的字符数据，载荷中的 UTF-8 数据必须是按照 Unicode 的规范和 RFC 3629 的标准要求进行编码的")
    @JsonProperty("payload_format_indicator")
    private Integer payloadFormatIndicator;

    @Schema(name = "消息过期间隔标识符", title = "以秒为单位", description = "当消失已经过期时，如果服务端还没有开始向匹配的订阅者投递该消息，则服务端会删除该订阅者的消息副本。如果不设置，则消息永远不会过期")
    @JsonProperty("message_expiry_interval")
    private Integer messageExpiryInterval;

    @Schema(name = "响应主题标识符", description = "UTF-8 编码的字符串，用作响应消息的主题名。响应主题不能包含通配符，也不能包含多个主题，否则将造成协议错误。当存在响应主题时，消息将被视作请求报文。服务端在收到应用消息时必须将响应主题原封不动的发送给所有的订阅者")
    @JsonProperty("response_topic")
    private String responseTopic;

    @Schema(name = "对比数据标识符", description = "服务端在收到应用消息时必须原封不动的把对比数据发送给所有的订阅者。对比数据只对请求消息(Request Message)的发送端和响应消息(Response Message)的接收端有意义")
    @JsonProperty("correlation_data")
    private String correlationData;

    @Schema(name = "指定 MQTT 消息的 User Property 键值对", description = "注意，如果出现重复的键，只有最后一个会保留")
    @JsonProperty("user_properties")
    private Map<String, Object> userProperties;

    @Schema(name = "内容类型标识符", description = "以 UTF-8 格式编码的字符串，用来描述应用消息的内容，服务端必须把收到的应用消息中的内容类型原封不动的发送给所有的订阅者。")
    @JsonProperty("content_type")
    private String contentType;

    public Integer getPayloadFormatIndicator() {
        return payloadFormatIndicator;
    }

    public void setPayloadFormatIndicator(Integer payloadFormatIndicator) {
        this.payloadFormatIndicator = payloadFormatIndicator;
        put("payload_format_indicator", payloadFormatIndicator);
    }

    public Integer getMessageExpiryInterval() {
        return messageExpiryInterval;
    }

    public void setMessageExpiryInterval(Integer messageExpiryInterval) {
        this.messageExpiryInterval = messageExpiryInterval;
        put("message_expiry_interval", messageExpiryInterval);
    }

    public String getResponseTopic() {
        return responseTopic;
    }

    public void setResponseTopic(String responseTopic) {
        this.responseTopic = responseTopic;
        put("response_topic", responseTopic);
    }

    public String getCorrelationData() {
        return correlationData;
    }

    public void setCorrelationData(String correlationData) {
        this.correlationData = correlationData;
        put("correlation_data", correlationData);
    }

    public Map<String, Object> getUserProperties() {
        return userProperties;
    }

    public void setUserProperties(Map<String, Object> userProperties) {
        this.userProperties = userProperties;
        put("user_properties", userProperties);
    }

    public String getContentType() {
        return contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
        put("content_type", contentType);
    }
}
