/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Cloud.
 *
 * Herodotus Cloud is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Cloud is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.openapi.emqx.config;

import cn.herodotus.stirrup.openapi.emqx.annotation.ConditionalOnEmqxEnabled;
import cn.herodotus.stirrup.openapi.emqx.core.EmqxTemplate;
import cn.herodotus.stirrup.openapi.emqx.properties.EmqxProperties;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.function.client.WebClient;

/**
 * <p>Description: Emqx Open API 模块配置 </p>
 *
 * @author : gengwei.zheng
 * @date : 2023/10/9 22:32
 */
@Configuration(proxyBeanMethods = false)
@ConditionalOnEmqxEnabled
@EnableConfigurationProperties(EmqxProperties.class)
@ComponentScan(basePackages = {
        "cn.herodotus.stirrup.openapi.emqx.service",
})
public class OpenApiEmqxConfiguration {

    private static final Logger log = LoggerFactory.getLogger(OpenApiEmqxConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- Module [Open API Emqx] Auto Configure.");
    }

    @Bean
    @ConditionalOnMissingBean
    public EmqxTemplate emqxTemplate(WebClient webClient, EmqxProperties emqxProperties) {
        EmqxTemplate template = new EmqxTemplate(webClient, emqxProperties);
        log.trace("[Herodotus] |- Bean [Emqx Template] Auto Configure.");
        return template;
    }
}
