/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Cloud.
 *
 * Herodotus Cloud is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Cloud is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.openapi.emqx.condition;

import cn.herodotus.stirrup.core.foundation.context.PropertyResolver;
import cn.herodotus.stirrup.openapi.core.constants.OpenApiConstants;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

/**
 * <p>Description: Emqx 注入开启条件 </p>
 *
 * @author : gengwei.zheng
 * @date : 2023/10/9 23:51
 */
public class EmqxEnabledCondition implements Condition {

    private static final Logger log = LoggerFactory.getLogger(EmqxEnabledCondition.class);

    @SuppressWarnings("NullableProblems")
    @Override
    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        String apiKey = PropertyResolver.getProperty(context, OpenApiConstants.ITEM_EMQX_API_KEY);
        String secretKey = PropertyResolver.getProperty(context, OpenApiConstants.ITEM_EMQX_SECRET_KEY);
        boolean result = StringUtils.isNotBlank(apiKey) && StringUtils.isNotBlank(secretKey);
        log.debug("[Herodotus] |- Condition [Emqx Configured] value is [{}]", result);
        return result;
    }
}
