/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.openapi.aliyun.audit.service;

import cn.herodotus.stirrup.openapi.aliyun.audit.definition.domain.Response;
import cn.herodotus.stirrup.openapi.aliyun.audit.definition.service.AbstractScanService;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.video.VideoQueryResponse;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.voice.VoiceAsyncRequest;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.voice.VoiceAsyncResponse;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.voice.VoiceSyncRequest;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.voice.VoiceSyncResponse;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.green.model.v20180509.VoiceAsyncScanRequest;
import com.aliyuncs.green.model.v20180509.VoiceAsyncScanResultsRequest;
import com.aliyuncs.green.model.v20180509.VoiceSyncScanRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>Description: 阿里声音审核服务类 </p>
 *
 * @author : gengwei.zheng
 * @date : 2021/4/14 15:03
 */
@Service
public class VoiceScanService extends AbstractScanService {

    private static final Logger log = LoggerFactory.getLogger(VoiceScanService.class);

    private final VoiceSyncScanRequest voiceSyncScanRequest;
    private final VoiceAsyncScanRequest voiceAsyncScanRequest;
    private final VoiceAsyncScanResultsRequest videoAsyncScanResultsRequest;

    public VoiceScanService(IAcsClient iAcsClient, VoiceSyncScanRequest voiceSyncScanRequest, VoiceAsyncScanRequest voiceAsyncScanRequest, VoiceAsyncScanResultsRequest videoAsyncScanResultsRequest) {
        super(iAcsClient);
        this.voiceSyncScanRequest = voiceSyncScanRequest;
        this.voiceAsyncScanRequest = voiceAsyncScanRequest;
        this.videoAsyncScanResultsRequest = videoAsyncScanResultsRequest;
    }

    public Response<List<VoiceSyncResponse>> syncScan(VoiceSyncRequest voiceSyncRequest) {
        String jsonString = this.scan(voiceSyncRequest, voiceSyncScanRequest);
        Response<List<VoiceSyncResponse>> entity = this.parseListResult(jsonString, VoiceSyncResponse.class);
        log.debug("[Herodotus] |- Aliyun Voice Sync Scan result is: {}", entity.toString());
        return entity;
    }

    public Response<List<VoiceAsyncResponse>> asyncScan(VoiceAsyncRequest voiceAsyncRequest) {
        String jsonString = this.scan(voiceAsyncRequest, voiceAsyncScanRequest);
        Response<List<VoiceAsyncResponse>> entity = this.parseListResult(jsonString, VoiceAsyncResponse.class);
        log.debug("[Herodotus] |- Aliyun Voice Async Scan result is: {}", entity.toString());
        return entity;
    }

    public Response<List<VideoQueryResponse>> queryResult(List<String> taskIds) {
        String jsonString = this.query(taskIds, videoAsyncScanResultsRequest);
        Response<List<VideoQueryResponse>> entity = this.parseListResult(jsonString, VideoQueryResponse.class);
        log.debug("[Herodotus] |- Aliyun Video Async Scan Query Result is: {}", entity.toString());
        return entity;
    }
}
