/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.openapi.aliyun.audit.processor;

import cn.herodotus.stirrup.openapi.aliyun.audit.definition.service.AbstractScanChain;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.ScanRequest;
import cn.herodotus.stirrup.openapi.aliyun.audit.service.TextScanService;
import com.google.common.collect.ImmutableList;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hutool.core.text.StrUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;

/**
 * <p>Description: 阿里文本扫描链 </p>
 *
 * @author : gengwei.zheng
 * @date : 2021/4/23 13:50
 */
@Service
public class TextScanChain extends AbstractScanChain {

    private static final Logger log = LoggerFactory.getLogger(TextScanChain.class);

    private static final int CONTENT_LENGTH = 10000;

    private final TextScanService textScanService;

    public TextScanChain(TextScanService textScanService) {
        this.textScanService = textScanService;
    }

    @Override
    public boolean execute(ScanRequest scanRequest) {
        String content = scanRequest.getText();
        if (StringUtils.isNotBlank(content)) {
            int length = StrUtil.length(content);
            List<String> contents;
            if (length > CONTENT_LENGTH) {
                String[] texts = StrUtil.cut(content, CONTENT_LENGTH);
                contents = Arrays.asList(texts);
            } else {
                contents = ImmutableList.of(content);
            }
            return textScanService.executeScan(contents);
        }

        return false;
    }
}
