/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.openapi.aliyun.audit.domain.webpage;

import cn.herodotus.stirrup.openapi.aliyun.audit.definition.domain.AbstractTask;

/**
 * <p>Description: WebpageTask </p>
 *
 * @author : gengwei.zheng
 * @date : 2021/4/14 13:23
 */
public class WebpageTask extends AbstractTask {

    /**
     * 网页链接，支持HTTP、HTTP协议的网页检测。
     * 说明 url与content字段二选一。
     */
    private String url;

    /**
     * 检测网页对应的HTML纯文本。
     * 说明 url与content字段二选一。
     */
    private String content;

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }
}
