/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.openapi.aliyun.audit.domain.webpage;

import cn.herodotus.stirrup.openapi.aliyun.audit.definition.domain.AbstractAsyncRequest;
import com.google.common.base.MoreObjects;

import java.util.List;

/**
 * <p>Description: 阿里网页审核异步请求对象 </p>
 *
 * @author : gengwei.zheng
 * @date : 2021/4/14 13:32
 */
public class WebpageAsyncRequest extends AbstractAsyncRequest<WebpageTask> {

    /**
     * 表示网页文本要检测的场景，唯一取值：antispam。
     * 说明 textScenes和imageScenes至少选一个。
     */
    private List<String> textScenes;
    /**
     * 表示网页图片要检测的场景，取值：
     * porn：鉴黄
     * ad：广告
     * terrorism：暴恐涉政
     * live：不良场景
     * 说明 textScenes和imageScenes至少选一个。
     */
    private List<String> imageScenes;
    /**
     * 指定是否高亮显示违规内容，取值：
     * true：高亮显示违规内容。
     * false（默认）：不高亮显示违规内容。
     */
    private Boolean returnHighlightHtml;

    public List<String> getTextScenes() {
        return textScenes;
    }

    public void setTextScenes(List<String> textScenes) {
        this.textScenes = textScenes;
    }

    public List<String> getImageScenes() {
        return imageScenes;
    }

    public void setImageScenes(List<String> imageScenes) {
        this.imageScenes = imageScenes;
    }

    public Boolean getReturnHighlightHtml() {
        return returnHighlightHtml;
    }

    public void setReturnHighlightHtml(Boolean returnHighlightHtml) {
        this.returnHighlightHtml = returnHighlightHtml;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("returnHighlightHtml", returnHighlightHtml)
                .toString();
    }
}
