/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.openapi.aliyun.audit.domain.webpage;

import cn.herodotus.stirrup.openapi.aliyun.audit.definition.domain.AbstractResult;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.common.HintWordsInfo;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.common.SFaceData;
import com.google.common.base.MoreObjects;

import java.util.List;

/**
 * <p>Description: ImageResultInfo </p>
 *
 * @author : gengwei.zheng
 * @date : 2021/4/14 14:47
 */
public class ImageResultInfo extends AbstractResult {

    /**
     * 图片中含有广告或文字违规信息时，返回图片中广告文字命中的风险关键词信息。
     * 说明 只有图文违规（ad）场景会返回该结果。
     */
    private List<HintWordsInfo> hintWordsInfo;
    /**
     * 图片中包含暴恐识涉政内容时，返回识别出来的暴恐涉政信息。具体结构描述，请参见sfaceData。
     */
    private List<SFaceData> sfaceData;
    /**
     * 识别到的图片中的完整文字信息。
     * 说明 默认不返回。如果需要该结果，请提交工单联系我们进行配置。
     */
    private List<String> ocrData;

    public List<HintWordsInfo> getHintWordsInfo() {
        return hintWordsInfo;
    }

    public void setHintWordsInfo(List<HintWordsInfo> hintWordsInfo) {
        this.hintWordsInfo = hintWordsInfo;
    }

    public List<SFaceData> getSfaceData() {
        return sfaceData;
    }

    public void setSfaceData(List<SFaceData> sfaceData) {
        this.sfaceData = sfaceData;
    }

    public List<String> getOcrData() {
        return ocrData;
    }

    public void setOcrData(List<String> ocrData) {
        this.ocrData = ocrData;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .toString();
    }
}
