/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.openapi.aliyun.audit.domain.video;

import cn.herodotus.stirrup.openapi.aliyun.audit.definition.domain.SyncTask;
import com.google.common.base.MoreObjects;

import java.util.List;

/**
 * <p>Description: 阿里视频检查同步任务实体 </p>
 *
 * @author : gengwei.zheng
 * @date : 2021/4/14 11:54
 */
public class VideoSyncTask extends SyncTask {

    /**
     * 待检测视频的截帧信息。frames中的每个元素是个结构体，关于每个元素的具体结构描述，请参见frame。
     */
    private List<TaskFrame> frames;

    /**
     * 截帧地址的前缀，与frame.url一起组成截帧的完整地址。视频截帧的完整地址格式为framePrefix + frame.url，请参见frame
     */
    private String framePrefix;

    public List<TaskFrame> getFrames() {
        return frames;
    }

    public void setFrames(List<TaskFrame> frames) {
        this.frames = frames;
    }

    public String getFramePrefix() {
        return framePrefix;
    }

    public void setFramePrefix(String framePrefix) {
        this.framePrefix = framePrefix;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("framePrefix", framePrefix)
                .toString();
    }
}
