/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.openapi.aliyun.audit.domain.text;

import cn.herodotus.stirrup.openapi.aliyun.audit.definition.domain.AbstractFeedbackBody;
import com.google.common.base.MoreObjects;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * <p>Description:  阿里文本检测内容反馈请求实体 </p>
 *
 * @author : gengwei.zheng
 * @date : 2021/4/14 11:07
 */
@Schema(title = "阿里文本检测内容反馈请求参数实体")
public class TextFeedbackBody extends AbstractFeedbackBody {

    /**
     * 被检测的内容，最长10,000个字符。
     */
    @Schema(title = "被检测的内容，最长10,000个字符")
    private String content;

    /**
     * 反馈的分类，与具体的scene对应。关于取值范围的说明，请参见文本反垃圾scene和label说明。
     */
    @Schema(title = "反馈的分类，与具体的scene对应")
    private String label;
    /**
     * 备注，比如文本中的关键文字。
     */
    @Schema(title = "备注，比如文本中的关键文字")
    private String note;

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getNote() {
        return note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("content", content)
                .add("label", label)
                .add("note", note)
                .toString();
    }
}
