/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.openapi.aliyun.audit.domain.image;

import cn.herodotus.stirrup.openapi.aliyun.audit.definition.domain.AbstractResult;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.common.HintWordsInfo;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.common.LogoData;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.common.SFaceData;
import com.google.common.base.MoreObjects;

import java.util.List;

/**
 * <p>Description: 阿里图片审核返回值：result对应实体 </p>
 *
 * @author : gengwei.zheng
 * @date : 2021/4/12 16:50
 */
public class ImageResult extends AbstractResult {
    /**
     * 如果检测场景包含智能鉴黄（porn）和暴恐涉政（terrorism），则该字段可以返回检测结果的细分类标签。
     * 该字段默认不会返回。如果有需要，您可以提交工单联系我们进行配置，配置后才会返回。
     */
    private String sublabel;
    /**
     * 如果待检测图片因为过长被截断，该参数返回截断后的每一帧图像的临时访问地址。具体结构描述请参见frame。
     */
    private List<Frame> frames;
    /**
     * 图片中含有广告或文字违规信息时，返回图片中广告文字命中的风险关键词信息。具体结构描述，请参见hintWordsInfo。
     */
    private List<HintWordsInfo> hintWordsInfo;
    /**
     * 图片中含有二维码时，返回图片中所有二维码包含的文本信息。
     */
    private List<String> qrcodeData;
    /**
     * 返回图片中识别到的二维码的坐标信息，关于具体的结构描述，请参见qrcodeLocation。
     */
    private List<QrcodeLocation> qrcodeLocations;
    /**
     * 图片中含有小程序码时，返回小程序码的位置信息。关于具体结构的描述，请参见programCodeData。
     */
    private List<ProgramCodeData> programCodeData;
    /**
     * 图片中含有logo时，返回识别出来的logo信息。关于具体结构的描述，请参见logoData。
     */
    private List<LogoData> logoData;
    /**
     * 图片中包含暴恐识涉政内容时，返回识别出来的暴恐涉政信息。关于具体结构的描述，请参见sfaceData。
     */
    private List<SFaceData> sFaceData;
    /**
     * 识别到的图片中的完整文字信息。
     */
    private List<String> ocrData;


    public String getSublabel() {
        return sublabel;
    }

    public void setSublabel(String sublabel) {
        this.sublabel = sublabel;
    }

    public List<Frame> getFrames() {
        return frames;
    }

    public void setFrames(List<Frame> frames) {
        this.frames = frames;
    }

    public List<HintWordsInfo> getHintWordsInfo() {
        return hintWordsInfo;
    }

    public void setHintWordsInfo(List<HintWordsInfo> hintWordsInfo) {
        this.hintWordsInfo = hintWordsInfo;
    }

    public List<String> getQrcodeData() {
        return qrcodeData;
    }

    public void setQrcodeData(List<String> qrcodeData) {
        this.qrcodeData = qrcodeData;
    }

    public List<QrcodeLocation> getQrcodeLocations() {
        return qrcodeLocations;
    }

    public void setQrcodeLocations(List<QrcodeLocation> qrcodeLocations) {
        this.qrcodeLocations = qrcodeLocations;
    }

    public List<ProgramCodeData> getProgramCodeData() {
        return programCodeData;
    }

    public void setProgramCodeData(List<ProgramCodeData> programCodeData) {
        this.programCodeData = programCodeData;
    }

    public List<LogoData> getLogoData() {
        return logoData;
    }

    public void setLogoData(List<LogoData> logoData) {
        this.logoData = logoData;
    }

    public List<SFaceData> getsFaceData() {
        return sFaceData;
    }

    public void setsFaceData(List<SFaceData> sFaceData) {
        this.sFaceData = sFaceData;
    }

    public List<String> getOcrData() {
        return ocrData;
    }

    public void setOcrData(List<String> ocrData) {
        this.ocrData = ocrData;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("sublabel", sublabel)
                .toString();
    }
}
