/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.openapi.aliyun.audit.domain.common;

import com.google.common.base.MoreObjects;
import io.swagger.v3.oas.annotations.media.Schema;

import java.io.Serializable;

/**
 * <p>Description: 阿里图片审核请求：hibLibInfo对应实体 </p>
 *
 * @author : gengwei.zheng
 * @date : 2021/4/12 17:19
 */
@Schema(title = "阿里云内容检测通用同步检测请求额外信息实体")
public class HitLibInfo implements Serializable {

    /**
     * 文字命中的自定义文本内容。
     */
    @Schema(title = "文字命中的自定义文本内容")
    private String context;
    /**
     * 文字命中的自定义文本内容对应的库code。
     */
    @Schema(title = "文字命中的自定义文本内容对应的库code")
    private String libCode;
    /**
     * 文字命中的自定义文本内容对应的库名称。
     */
    @Schema(title = "文字命中的自定义文本内容对应的库名称")
    private String libName;

    public String getContext() {
        return context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getLibCode() {
        return libCode;
    }

    public void setLibCode(String libCode) {
        this.libCode = libCode;
    }

    public String getLibName() {
        return libName;
    }

    public void setLibName(String libName) {
        this.libName = libName;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("context", context)
                .add("libCode", libCode)
                .add("libName", libName)
                .toString();
    }
}
