/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.openapi.aliyun.audit.domain.callback;

import cn.herodotus.stirrup.openapi.aliyun.audit.definition.domain.AbstractSyncResponse;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.common.HitLibInfo;
import com.google.common.base.MoreObjects;

/**
 * <p>Description: 阿里内容审核异步审核Callback返回结果实体 </p>
 *
 * @author : gengwei.zheng
 * @date : 2021/4/20 15:46
 */
public class CallbackResponse extends AbstractSyncResponse<CallbackResult> {

    private HitLibInfo extras;

    private String url;

    public HitLibInfo getExtras() {
        return extras;
    }

    public void setExtras(HitLibInfo extras) {
        this.extras = extras;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("extras", extras)
                .add("url", url)
                .toString();
    }
}
