/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.openapi.aliyun.audit.definition.domain;

import com.google.common.base.MoreObjects;
import io.swagger.v3.oas.annotations.media.Schema;

import java.util.List;

/**
 * <p>Description: 请求基础抽象类 </p>
 *
 * @author : gengwei.zheng
 * @date : 2021/4/14 13:00
 */
public abstract class AbstractRequest<T extends AbstractTask> implements CoreRequest {
    /**
     * 该字段用于标识您的业务场景。您可以通过内容安全控制台创建业务场景（具体操作，请参见自定义机审标准），或者提交工单联系我们帮助您创建业务场景。
     */
    @Schema(title = "该字段用于标识您的业务场景", description = "您可以通过内容安全控制台创建业务场景（具体操作，请参见自定义机审标准），或者提交工单联系我们帮助您创建业务场景")
    private String bizType;

    /**
     * 指定检测对象，JSON数组中的每个元素是一个检测任务结构体。最多支持100个元素，即每次提交100条内容进行检测，支持100个元素的前提是需要将并发任务调整到100个以上。关于每个元素的具体结构描述，请参见task。
     */
    @Schema(title = "指定检测对象", required = true, description = "JSON数组中的每个元素是一个检测任务结构体。最多支持100个元素，即每次提交100条内容进行检测，支持100个元素的前提是需要将并发任务调整到100个以上")
    private List<T> tasks;

    public String getBizType() {
        return bizType;
    }

    public void setBizType(String bizType) {
        this.bizType = bizType;
    }

    public List<T> getTasks() {
        return tasks;
    }

    public void setTasks(List<T> tasks) {
        this.tasks = tasks;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("bizType", bizType)
                .toString();
    }
}
