/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君), <herodotus@aliyun.com> Licensed under the AGPL License
 *
 * This file is part of Herodotus Stirrup.
 *
 * Herodotus Stirrup is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Herodotus Stirrup is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.herodotus.vip>.
 */

package cn.herodotus.stirrup.openapi.aliyun.audit.constants;

/**
 * <p>Description: Aliyun Audit 常量 </p>
 *
 * @author : gengwei.zheng
 * @date : 2023/10/10 17:40
 */
public interface AliyunAuditConstants {

    /**
     * 涉政恐怖言论反垃圾antispam
     */
    String SCENE_ANTISPAM = "antispam";
    /**
     * 含垃圾信息
     */
    String SCENE_SPAM = "spam";
    /**
     * 广告
     */
    String SCENE_AD = "ad";
    /**
     * 涉政
     */
    String SCENE_POLITICS = "politics";
    /**
     * 暴恐
     */
    String SCENE_TERRORISM = "terrorism";
    /**
     * 辱骂
     */
    String SCENE_ABUSE = "abuse";
    /**
     * 色情
     */
    String SCENE_PORN = "porn";
    /**
     * 正常场景
     */
    String SCENE_NORMAL = "normal";
    /**
     * 灌水
     */
    String SCENE_FLOOD = "flood";
    /**
     * 违禁
     */
    String SCENE_CONTRABAND = "contraband";
    /**
     * 无意义
     */
    String SCENE_MEANINGLESS = "meaningless";
    /**
     * 自定义（例如命中自定义关键词）
     */
    String SCENE_CUSTOMIZED = "customized";
    /**
     * 该字段用于标识业务场景。针对不同的业务场景，您可以配置不同的内容审核策略，以满足不同场景下不同的审核标准或算法策略的需求。
     * 您可以通过云盾内容安全控制台创建业务场景（bizType），或者通过工单联系我们帮助您创建业务场景。
     */
    String BIZ_TYPE = "security_Policy";
}
