/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.openapi.aliyun.audit.service;

import cn.herodotus.stirrup.openapi.aliyun.audit.definition.domain.Response;
import cn.herodotus.stirrup.openapi.aliyun.audit.definition.service.AbstractScanService;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.video.VideoQueryResponse;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.voice.VoiceAsyncRequest;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.voice.VoiceAsyncResponse;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.voice.VoiceSyncRequest;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.voice.VoiceSyncResponse;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.green.model.v20180509.VoiceAsyncScanRequest;
import com.aliyuncs.green.model.v20180509.VoiceAsyncScanResultsRequest;
import com.aliyuncs.green.model.v20180509.VoiceSyncScanRequest;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class VoiceScanService
extends AbstractScanService {
    private static final Logger log = LoggerFactory.getLogger(VoiceScanService.class);
    private final VoiceSyncScanRequest voiceSyncScanRequest;
    private final VoiceAsyncScanRequest voiceAsyncScanRequest;
    private final VoiceAsyncScanResultsRequest videoAsyncScanResultsRequest;

    public VoiceScanService(IAcsClient iAcsClient, VoiceSyncScanRequest voiceSyncScanRequest, VoiceAsyncScanRequest voiceAsyncScanRequest, VoiceAsyncScanResultsRequest videoAsyncScanResultsRequest) {
        super(iAcsClient);
        this.voiceSyncScanRequest = voiceSyncScanRequest;
        this.voiceAsyncScanRequest = voiceAsyncScanRequest;
        this.videoAsyncScanResultsRequest = videoAsyncScanResultsRequest;
    }

    public Response<List<VoiceSyncResponse>> syncScan(VoiceSyncRequest voiceSyncRequest) {
        String jsonString = this.scan(voiceSyncRequest, this.voiceSyncScanRequest);
        Response<List<VoiceSyncResponse>> entity = this.parseListResult(jsonString, VoiceSyncResponse.class);
        log.debug("[Herodotus] |- Aliyun Voice Sync Scan result is: {}", (Object)entity.toString());
        return entity;
    }

    public Response<List<VoiceAsyncResponse>> asyncScan(VoiceAsyncRequest voiceAsyncRequest) {
        String jsonString = this.scan(voiceAsyncRequest, this.voiceAsyncScanRequest);
        Response<List<VoiceAsyncResponse>> entity = this.parseListResult(jsonString, VoiceAsyncResponse.class);
        log.debug("[Herodotus] |- Aliyun Voice Async Scan result is: {}", (Object)entity.toString());
        return entity;
    }

    public Response<List<VideoQueryResponse>> queryResult(List<String> taskIds) {
        String jsonString = this.query(taskIds, this.videoAsyncScanResultsRequest);
        Response<List<VideoQueryResponse>> entity = this.parseListResult(jsonString, VideoQueryResponse.class);
        log.debug("[Herodotus] |- Aliyun Video Async Scan Query Result is: {}", (Object)entity.toString());
        return entity;
    }
}

