/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.openapi.aliyun.audit.service;

import cn.herodotus.stirrup.openapi.aliyun.audit.definition.domain.CoreResponse;
import cn.herodotus.stirrup.openapi.aliyun.audit.definition.domain.Response;
import cn.herodotus.stirrup.openapi.aliyun.audit.definition.service.AbstractScanService;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.video.VideoAsyncRequest;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.video.VideoAsyncResponse;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.video.VideoAsyncTask;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.video.VideoQueryResponse;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.video.VideoSyncRequest;
import cn.herodotus.stirrup.openapi.aliyun.audit.domain.video.VideoSyncResponse;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.green.model.v20180509.VideoAsyncScanRequest;
import com.aliyuncs.green.model.v20180509.VideoAsyncScanResultsRequest;
import com.aliyuncs.green.model.v20180509.VideoSyncScanRequest;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class VideoScanService
extends AbstractScanService {
    private static final Logger log = LoggerFactory.getLogger(VideoScanService.class);
    private final VideoSyncScanRequest videoSyncScanRequest;
    private final VideoAsyncScanRequest videoAsyncScanRequest;
    private final VideoAsyncScanResultsRequest videoAsyncScanResultsRequest;

    public VideoScanService(IAcsClient iAcsClient, VideoSyncScanRequest videoSyncScanRequest, VideoAsyncScanRequest videoAsyncScanRequest, VideoAsyncScanResultsRequest videoAsyncScanResultsRequest) {
        super(iAcsClient);
        this.videoSyncScanRequest = videoSyncScanRequest;
        this.videoAsyncScanRequest = videoAsyncScanRequest;
        this.videoAsyncScanResultsRequest = videoAsyncScanResultsRequest;
    }

    public Response<List<VideoSyncResponse>> syncScan(VideoSyncRequest videoSyncRequest) {
        String jsonString = this.scan(videoSyncRequest, this.videoSyncScanRequest);
        Response<List<VideoSyncResponse>> entity = this.parseListResult(jsonString, VideoSyncResponse.class);
        log.debug("[Herodotus] |- Aliyun Video Sync Scan result is: {}", (Object)entity.toString());
        return entity;
    }

    public Response<List<VideoAsyncResponse>> asyncScan(VideoAsyncRequest videoAsyncRequest) {
        String jsonString = this.scan(videoAsyncRequest, this.videoAsyncScanRequest);
        Response<List<VideoAsyncResponse>> entity = this.parseListResult(jsonString, VideoAsyncResponse.class);
        log.debug("[Herodotus] |- Aliyun Video Async Scan result is: {}", (Object)entity.toString());
        return entity;
    }

    public Response<List<VideoQueryResponse>> queryResult(List<String> taskIds) {
        String jsonString = this.query(taskIds, this.videoAsyncScanResultsRequest);
        Response<List<VideoQueryResponse>> entity = this.parseListResult(jsonString, VideoQueryResponse.class);
        log.debug("[Herodotus] |- Aliyun Video Async Scan Query Result is: {}", (Object)entity.toString());
        return entity;
    }

    public VideoAsyncRequest buildAsyncRequest(List<VideoAsyncTask> tasks, List<String> scenes, String bizType, String seed, String callback) {
        VideoAsyncRequest videoAsyncRequest = new VideoAsyncRequest();
        videoAsyncRequest.setBizType(bizType);
        videoAsyncRequest.setScenes(scenes);
        videoAsyncRequest.setTasks(tasks);
        if (StringUtils.isNotBlank((CharSequence)seed) && StringUtils.isNotBlank((CharSequence)callback)) {
            videoAsyncRequest.setSeed(seed);
            videoAsyncRequest.setCallback(callback);
        }
        return videoAsyncRequest;
    }

    public VideoAsyncRequest buildDefaultAsyncRequest(List<String> urls, String seed, String callback) {
        List<VideoAsyncTask> tasks = urls.stream().map(url -> {
            VideoAsyncTask videoAsyncTask = new VideoAsyncTask();
            videoAsyncTask.setUrl((String)url);
            return videoAsyncTask;
        }).collect(Collectors.toList());
        ImmutableList scenes = ImmutableList.of((Object)"porn", (Object)"terrorism");
        return this.buildAsyncRequest(tasks, (List<String>)scenes, "security_Policy", seed, callback);
    }

    public VideoAsyncRequest buildDefaultAsyncRequest(List<String> urls) {
        return this.buildDefaultAsyncRequest(urls, null, null);
    }

    public List<String> asyncAnalyse(List<VideoAsyncResponse> responses) {
        return responses.stream().map(CoreResponse::getTaskId).collect(Collectors.toList());
    }

    public List<String> executeScan(List<String> videoUrls) {
        return this.executeScan(videoUrls, null, null);
    }

    public List<String> executeScan(List<String> videoUrls, String seed, String callback) {
        VideoAsyncRequest videoAsyncRequest = this.buildDefaultAsyncRequest(videoUrls, seed, callback);
        Response<List<VideoAsyncResponse>> response = this.asyncScan(videoAsyncRequest);
        if (response.getCode().equals(200)) {
            return this.asyncAnalyse(response.getData());
        }
        log.error("[Herodotus] |- Aliyun Video Async Scan catch error! result: {}", response);
        return new ArrayList<String>();
    }
}

